/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.remote;

import cz.insophy.inplan.remote.ServerManager;
import cz.insophy.inplan.remote.UserAuthenticationException;
import java.util.Collections;
import java.util.List;
import org.apache.http.conn.HttpHostConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;

public abstract class InSecurityManager {
    private static Logger log = LoggerFactory.getLogger(InSecurityManager.class);
    private static String username;
    private static String password;
    private static List<String> userRoles;
    private static boolean sane;
    private static final String BACKDOOR_PROPERTY = "backdoor";

    public static boolean isBackdoorEnabled() {
        return System.getProperty(BACKDOOR_PROPERTY) != null;
    }

    public static String getUsername() {
        InSecurityManager.checkSanity();
        if (InSecurityManager.isBackdoorEnabled()) {
            return "";
        }
        return username;
    }

    public static boolean hasUserRole(String userRole) {
        InSecurityManager.checkSanity();
        return InSecurityManager.isBackdoorEnabled() || userRoles.contains("ROOT") || userRoles.contains(userRole);
    }

    public static Access login(String username, String password) throws HttpClientErrorException, HttpHostConnectException {
        try {
            Boolean accessAllowed = ServerManager.checkAccess();
            if (accessAllowed == null) {
                return Access.UNAVAILABLE;
            }
            if (!accessAllowed.booleanValue()) {
                return Access.DENIED;
            }
            ServerManager.setCredentials(username, password);
            userRoles = ServerManager.getUserRoles();
            InSecurityManager.username = username;
            InSecurityManager.password = password;
            sane = true;
            return Access.OK;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            if (InSecurityManager.username != null) {
                try {
                    ServerManager.setCredentials(InSecurityManager.username, InSecurityManager.password);
                }
                catch (Exception e2) {
                    log.error("Could not restore the server manager to current credentials", e2);
                }
            }
            if (e instanceof HttpClientErrorException) {
                throw (HttpClientErrorException)e;
            }
            if (e instanceof HttpHostConnectException) {
                throw (HttpHostConnectException)e;
            }
            return Access.UNAVAILABLE;
        }
    }

    public static void checkSanity() {
        if (!InSecurityManager.isSane()) {
            throw new UserAuthenticationException();
        }
    }

    public static boolean isSane() {
        return InSecurityManager.isBackdoorEnabled() || sane;
    }

    static {
        userRoles = Collections.emptyList();
        sane = false;
    }

    public static enum Access {
        OK,
        DENIED,
        UNAVAILABLE;

    }
}

